/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8229.DeviceView;

import ibm.nways.jdm.common.OID;
import ibm.nways.jdm8229.DeviceView.ChassisIntegrated;
import ibm.nways.jdm8229.DeviceView.ChassisLike;
import ibm.nways.jdm8229.DeviceView.ChassisStandAlone;
import ibm.nways.jdm8229.DeviceView.ChassisUnknown;
import ibm.nways.jdm8229.DeviceView.FactoryLike;
import ibm.nways.ras.RAS;
import java.io.Serializable;

public class Factory
implements FactoryLike {
    private static final FactoryLike instance = new Factory();

    private Factory() {
    }

    public static FactoryLike getInstance() {
        return instance;
    }

    public ChassisLike createChassis(Serializable serializable) {
        if (serializable instanceof OID) {
            String string = serializable.toString();
            if (string.equals("1.3.6.1.4.1.2.6.23")) {
                if (RAS.isEnabled(19, 3)) {
                    RAS.trace(19, 3, this, "createChassis", "Stand Alone 8229 created.");
                }
                return new ChassisStandAlone();
            }
            if (string.equals("1.3.6.1.4.1.2.6.101")) {
                if (RAS.isEnabled(19, 3)) {
                    RAS.trace(19, 3, this, "createChassis", "Integrated 8229 created.");
                }
                return new ChassisIntegrated();
            }
        }
        if (RAS.isEnabled(19, 3)) {
            RAS.trace(19, 3, this, "createChassis", "Unknown 8229 created.");
        }
        return new ChassisUnknown();
    }
}

